/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import io.github.fabricators_of_create.porting_lib.block.CustomRunningEffectsBlock;
import java.lang.ref.Reference;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3499;
import net.minecraft.class_5819;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class EntityContraptionInteractionMixin {
    private final class_1297 self = (class_1297)this;
    private AbstractContraptionEntity contraption;
    @Final
    @Shadow
    protected class_5819 field_5974;
    @Shadow
    private float field_6003;

    @Shadow
    protected abstract float method_5867();

    @Shadow
    protected abstract void method_5712(class_2338 var1, class_2680 var2);

    private Set<AbstractContraptionEntity> getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = this.getIntersectionContraptionsStream().collect(Collectors.toSet());
        contraptions.addAll(this.self.field_6002.method_18467(AbstractContraptionEntity.class, this.self.method_5829().method_1014(1.0)));
        return contraptions;
    }

    private Stream<AbstractContraptionEntity> getIntersectionContraptionsStream() {
        return ContraptionHandler.loadedContraptions.get((class_1936)this.self.field_6002).values().stream().map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey(this.self));
    }

    private void forCollision(class_243 anchorPos, TriConsumer<Contraption, class_2680, class_2338> action) {
        this.getIntersectingContraptions().forEach(cEntity -> {
            class_243 localPos = ContraptionCollider.getWorldToLocalTranslation(anchorPos, cEntity);
            localPos = anchorPos.method_1019(localPos);
            class_2338 blockPos = new class_2338(localPos);
            Contraption contraption = cEntity.getContraption();
            class_3499.class_3501 info = contraption.getBlocks().get(blockPos);
            if (info != null) {
                class_2680 blockstate = info.field_15596;
                action.accept((Object)contraption, (Object)blockstate, (Object)blockPos);
            }
        });
    }

    @Inject(at={@At(value="JUMP", opcode=154, ordinal=7)}, method={"move"})
    private void movementStepMixin(class_1313 mover, class_243 movement, CallbackInfo ci) {
        class_243 worldPos = this.self.method_19538().method_1031(0.0, -0.2, 0.0);
        AtomicBoolean stepped = new AtomicBoolean(false);
        this.forCollision(worldPos, (TriConsumer<Contraption, class_2680, class_2338>)((TriConsumer)(contraption, blockstate, blockPos) -> {
            this.bindContraption((Contraption)contraption);
            this.method_5712((class_2338)blockPos, (class_2680)blockstate);
            this.unbindContraption();
            stepped.set(true);
        }));
        if (stepped.get()) {
            this.field_6003 = this.method_5867();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"move"})
    private void movementMixin(class_1313 mover, class_243 movement, CallbackInfo ci) {
        if (!this.self.field_6002.field_9236) {
            return;
        }
        if (this.self.method_24828()) {
            return;
        }
        if (this.self.method_5765()) {
            return;
        }
        class_243 worldPos = this.self.method_19538().method_1031(0.0, -0.2, 0.0);
        boolean onAtLeastOneContraption = this.getIntersectionContraptionsStream().anyMatch(cEntity -> {
            class_243 localPos = ContraptionCollider.getWorldToLocalTranslation(worldPos, cEntity);
            localPos = worldPos.method_1019(localPos);
            class_2338 blockPos = new class_2338(localPos);
            Contraption contraption = cEntity.getContraption();
            class_3499.class_3501 info = contraption.getBlocks().get(blockPos);
            if (info == null) {
                return false;
            }
            cEntity.registerColliding(this.self);
            return true;
        });
        if (!onAtLeastOneContraption) {
            return;
        }
        this.self.method_24830(true);
        this.self.getExtraCustomData().method_10556("ContraptionGrounded", true);
    }

    @Inject(method={"spawnSprintParticle"}, at={@At(value="TAIL")})
    private void createRunningParticlesMixin(CallbackInfo ci) {
        class_243 worldPos = this.self.method_19538().method_1031(0.0, -0.2, 0.0);
        class_2338 pos = new class_2338(worldPos);
        this.forCollision(worldPos, (TriConsumer<Contraption, class_2680, class_2338>)((TriConsumer)(contraption, blockstate, blockpos) -> {
            CustomRunningEffectsBlock custom;
            boolean particles = blockstate.method_26217() != class_2464.field_11455;
            class_2248 patt5393$temp = blockstate.method_26204();
            if (patt5393$temp instanceof CustomRunningEffectsBlock && (custom = (CustomRunningEffectsBlock)patt5393$temp).addRunningEffects(blockstate, this.self.field_6002, blockpos, this.self)) {
                particles = false;
            }
            if (particles) {
                class_243 vec3d = this.self.method_18798();
                this.self.field_6002.method_8406((class_2394)new class_2388(class_2398.field_11217, blockstate), this.self.method_23317() + ((double)this.field_5974.method_43057() - 0.5) * (double)this.self.method_17681(), this.self.method_23318() + 0.1, this.self.method_23321() + ((double)this.field_5974.method_43057() - 0.5) * (double)this.self.method_17681(), vec3d.field_1352 * -4.0, 1.5, vec3d.field_1350 * -4.0);
            }
        }));
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void playSoundShifted(class_3414 event, float pitch, float volume, CallbackInfo ci) {
        if (this.contraption != null && (!this.self.method_5701() || this.self instanceof class_1657)) {
            double x = this.self.method_23317();
            double y = this.self.method_23318();
            double z = this.self.method_23321();
            class_243 worldPos = ContraptionCollider.getWorldToLocalTranslation(new class_243(x, y, z), this.contraption);
            worldPos = worldPos.method_1031(x, y, z);
            this.self.field_6002.method_43128(null, worldPos.field_1352 + x, worldPos.field_1351 + y, worldPos.field_1350 + z, event, this.self.method_5634(), pitch, volume);
            ci.cancel();
        }
    }

    private void bindContraption(Contraption contraption) {
        this.bindContraption(contraption.entity);
    }

    private void bindContraption(AbstractContraptionEntity contraption) {
        this.contraption = contraption;
    }

    private void unbindContraption() {
        this.contraption = null;
    }
}

